#include <iostream>
#include <stack>
#include <vector>

using namespace std;

int nadji_rastojanje_ako_je_k_poz(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (tr_y - y2 + x2);
	return x_presecne_tacke - tr_x;
}
int nadji_rastojanje_ako_je_k_neg(int tr_x, int tr_y, int x2, int y2){
	int x_presecne_tacke = (x2 + y2 - tr_y);
	return tr_x - x_presecne_tacke;
//	return x_presecne_tacke;
}
void prvi_veci_sa_desne(vector<int>& poz_y, vector<int>& poz_pvd, int n){
	stack<int> stek;
	for(int i = 0; i < n; i++){
		while(!stek.empty() and poz_y[i] >= poz_y[stek.top()]){
			poz_pvd[stek.top()] = i;
			stek.pop();
		}
		stek.push(i);
	}
}
void prvi_veci_sa_leve(vector<int>& poz_y, vector<int>& poz_pvl, int n){
	stack<int> stek;
	for(int i = n-1; i >= 0; i--){
		while(!stek.empty() and poz_y[i] >= poz_y[stek.top()]){
			poz_pvl[stek.top()] = i;
			stek.pop();
		}
		stek.push(i);
	}
}

int main(){
	int n;
	cin >> n;
	vector<int> poz_x(n);
	for(int i = 0; i < n; i++){
		cin >> poz_x[i];
	}
	
	int max_visina = 0;
	vector<int> poz_y(n);
	for(int i = 0; i < n; i++){
		cin >> poz_y[i];
		if(poz_y[i] > max_visina){
			max_visina = poz_y[i];
		}
	}
	vector<int> poz_pvd(n, -1);
	prvi_veci_sa_desne(poz_y, poz_pvd, n);
	
	vector<int> poz_pvl(n, -1);
	prvi_veci_sa_leve(poz_y, poz_pvl, n);
	
//	for(int i = 0; i < n; i++){
//		cout << i << " " << poz_pvl[i] << " " << poz_pvd[i] << endl;
//	}
//	
	for(int i = 0; i < n; i++){
		if(poz_pvd[i] == -1 and poz_pvl[i] == -1){
//			cout << "da ";
			cout << -1 << '\n';
		}
		else if(poz_pvd[i] == -1){
			cout << nadji_rastojanje_ako_je_k_neg(poz_x[i], poz_y[i], poz_x[poz_pvl[i]], poz_y[poz_pvl[i]]) << '\n';
		}
		else if(poz_pvl[i] == -1){
//			cout << " da " << poz_x[i] << " " << poz_y[i] << " " << " " << poz_x[poz_pvd[i]] << " " << poz_y[poz_pvd[i]] << " ";
			cout << nadji_rastojanje_ako_je_k_poz(poz_x[i], poz_y[i], poz_x[poz_pvd[i]], poz_y[poz_pvd[i]]) << '\n';
		}
		else if(poz_pvd[i] - i <= i - poz_pvl[i]){
			cout << nadji_rastojanje_ako_je_k_poz(poz_x[i], poz_y[i], poz_x[poz_pvd[i]], poz_y[poz_pvd[i]]) << '\n';
		}
		else if(poz_pvd[i] - i > i - poz_pvl[i]){
			cout << nadji_rastojanje_ako_je_k_neg(poz_x[i], poz_y[i], poz_x[poz_pvl[i]], poz_y[poz_pvl[i]]) << '\n';
		}
	}
	
	return 0;
}